#include <bits/stdc++.h>
using namespace std;
using ll = long long;

struct Point { 
    double x,y; 
};

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n;
    double eps;
    if(!(cin >> n >> eps)) return 0;
    vector<Point> p(n);
    for(int i=0;i<n;i++){
        cin >> p[i].x >> p[i].y;
    }

    double Ld = 18.0 / (eps*eps);
    long long L = (long long) floor(Ld + 1e-12);
    if(L < 1) L = 1;

    vector<int> chosen_idx;

    if((long long)n <= L){
        chosen_idx.resize(n);
        iota(chosen_idx.begin(), chosen_idx.end(), 0);
    } else {
        double s = eps / 2.0;
        if(s <= 0) s = eps; 
        int nx = max(1, (int)ceil(1.0 / s));
        int ny = nx;
        unordered_map<long long, pair<int,double>> cell_best;
        cell_best.reserve(min(n, (int)nx*ny)*2);

        for(int i=0;i<n;i++){
            int cx = min(nx-1, max(0, (int)floor(p[i].x / s)));
            int cy = min(ny-1, max(0, (int)floor(p[i].y / s)));
            long long key = ((long long)cx << 32) ^ (unsigned long long)cy;
            double cx_center = (cx + 0.5) * s;
            double cy_center = (cy + 0.5) * s;
            double dx = fabs(p[i].x - cx_center);
            double dy = fabs(p[i].y - cy_center);
            double man = dx + dy;
            auto it = cell_best.find(key);
            if(it == cell_best.end() || man < it->second.second){
                cell_best[key] = {i, man};
            }
        }

        chosen_idx.reserve(cell_best.size());
        vector<pair<long long,int>> order;
        order.reserve(cell_best.size());
        for(auto &kv : cell_best){
            order.push_back({kv.first, kv.second.first});
        }
        sort(order.begin(), order.end(), [](auto &a, auto &b){ return a.first < b.first; });

        for(size_t i=0;i<order.size() && (long long)chosen_idx.size() < L; ++i){
            chosen_idx.push_back(order[i].second);
        }

        if(chosen_idx.empty()){
            for(int i=0;i< (int)min((long long)n, L); ++i) chosen_idx.push_back(i);
        }
    }

    int k = (int)chosen_idx.size();
    cout << k << '\n';
    for(int i=0;i<k;i++){
        cout << (chosen_idx[i] + 1) << (i+1==k?'\n':' ');
    }
    if(k <= 1) return 0;

    vector<char> used(k, 0);
    vector<double> bestd(k, 1e300);
    vector<int> parent(k, -1);
    bestd[0] = 0.0;
    vector<Point> cpts(k);
    for(int i=0;i<k;i++) cpts[i] = p[ chosen_idx[i] ];

    for(int it=0; it<k; ++it){
        int v = -1;
        double mind = 1e300;
        for(int i=0;i<k;i++){
            if(!used[i] && bestd[i] < mind){
                mind = bestd[i];
                v = i;
            }
        }
        if(v == -1) break;
        used[v] = 1;

        for(int u=0; u<k; ++u){
            if(used[u]) continue;
            double d = fabs(cpts[v].x - cpts[u].x) + fabs(cpts[v].y - cpts[u].y);
            if(d < bestd[u]){
                bestd[u] = d;
                parent[u] = v;
            }
        }
    }

    for(int i=1;i<k;i++){
        int a = chosen_idx[i] + 1;
        int b = chosen_idx[ parent[i] ] + 1;
        cout << a << ' ' << b << '\n';
    }
    return 0;
}